function weightSimilarity(obj,varargin)
%UNTITLED5 Summary of this function goes here
%   Detailed explanation goes here



if ~isempty(obj.groups)
    
    outMat = combineCells(obj.adjMat,{},obj.groups);
    inMat = combineCells(obj.adjMat,obj.groups,{});
    [Aout outRowLabs outColLabs] = getMatrix(outMat);
    [Ain inRowLabs inColLabs] = getMatrix(inMat);
    switch obj.direction
        case 'outgoing'
            num = makeMat(Aout);
            obj.Slabels = outRowLabs;
        case 'incoming'
            num = makeMat(Ain');
            obj.Slabels = inColLabs;
        case 'both'
            % This is kind of tricky; need to consider cells that have no
            % output or input since AdjacencyMatrix will remove the rows
            % automatically
            [A fullLabels] = getSquareMatrix(obj.adjMat);
            [t tmpOutMat] = getSubMatrix(outMat,fullLabels,outColLabs);
            
            % Remove group name labels
%             [C idxs2Keep] = setdiff(tmpOutLabels,{obj.groups{1:2:end}});
% %             {obj.groups{1:2:end}}
%             tmpOutMat = tmpOutMat(idxs2Keep,:);
%             tmpOutLabels = tmpOutLabels(idxs2Keep);            
%             tmpOutLabels

            outSim = makeMat(tmpOutMat);
            [subMat tmpInMat] = getSubMatrix(inMat,inRowLabs,fullLabels);
            inSim = makeMat(tmpInMat');
            num = outSim + inSim;
            obj.Slabels = fullLabels;
            
%             [num obj.Slabels] = getSquareMatrix(num);
    end
    
    
else
    switch obj.direction
        case 'outgoing'
            [A obj.Slabels tmp] = getMatrix(obj.adjMat);
            num = makeMat(A);
        case 'incoming'
            [A tmp obj.Slabels] = getMatrix(obj.adjMat);
            num = makeMat(A');
        case 'both'        
            [A obj.Slabels] = getSquareMatrix(obj.adjMat);
            num = makeMat(A) + makeMat(A');

    end
    
end
% size(Aout)
% size(Ain)


% Various ways of normalizing
% denom = (diag(num) * diag(num)').^(1/2);
% N = size(num,1);
% denom = repmat(diag(num),[1 N]) + repmat(diag(num)',[N 1]);
% denom = denom./2;

denom = 1;
obj.S = num./denom;

% Form histogram
% tmp = triu(obj.S,1);
% tmp(logical(tril(ones(size(tmp)),1))) = -Inf;
% hist(tmp(~isinf(tmp)),max(10,size(obj.S,1)/5)); title('Histogram of similarity values');

%     function Ssol = iterMakeMat(adjMat)
%         nIters = 100;
%         for N = 1:nIters
%             for i = 1:size(adjMat,1)
%                 for j = 1:size(adjMat,1)
%                 end
%             end
%         end
%         
%     end

    function S = makeMat(adjMat)   %Form the similarity matrix
        S = zeros(size(adjMat,1));
        
        for i = 1:size(adjMat,1)
            for j = i:size(adjMat,1)
                S(i,j) = sum(weightSim(adjMat(i,:),adjMat(j,:)));
                
            end
        end
        S2 = triu(S,1)';
        S = S + S2;
        
    end
end

